/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import com.google.common.collect.ImmutableList;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.mantle.util.SingleKeyMultimap;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class ToolAttackUtil {
    private static final UUID OFFHAND_DAMAGE_MODIFIER_UUID = UUID.fromString("fd666e50-d2cc-11eb-b8bc-0242ac130003");
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final class_1322 ANTI_KNOCKBACK_MODIFIER = new class_1322("tconstruct.anti_knockback", 1.0, class_1322.class_1323.field_6328);
    public static final DoubleSupplier NO_COOLDOWN = () -> 1.0;

    public static DoubleSupplier getCooldownFunction(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5810) {
            return () -> OffhandCooldownTracker.getCooldown(player);
        }
        return () -> player.method_7261(0.5f);
    }

    public static float getAttributeAttackDamage(IToolStackView tool, class_1309 holder, class_1304 slotType) {
        if (slotType == class_1304.field_6173 || holder.method_37908().field_9236) {
            return (float)holder.method_26825(class_5134.field_23721);
        }
        class_1799 mainStack = holder.method_6047();
        SingleKeyMultimap mainModifiers = null;
        if (!mainStack.method_7960()) {
            mainModifiers = new SingleKeyMultimap(class_5134.field_23721, holder.method_6047().method_7926(class_1304.field_6173).get((Object)class_5134.field_23721));
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)new class_1322(OFFHAND_DAMAGE_MODIFIER_UUID, "tconstruct.tool.offhand_attack_damage", (double)tool.getStats().get(ToolStats.ATTACK_DAMAGE).floatValue(), class_1322.class_1323.field_6328));
        BiConsumer<class_1320, class_1322> attributeConsumer = (attribute, modifier) -> {
            if (attribute == class_5134.field_23721) {
                listBuilder.add(modifier);
            }
        };
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(TinkerHooks.ATTRIBUTES).addAttributes(tool, entry, class_1304.field_6173, attributeConsumer);
        }
        SingleKeyMultimap offhandModifiers = new SingleKeyMultimap(class_5134.field_23721, listBuilder.build());
        class_5131 modifiers = holder.method_6127();
        if (mainModifiers != null) {
            modifiers.method_26847(mainModifiers);
        }
        modifiers.method_26854(offhandModifiers);
        float damage = (float)holder.method_26825(class_5134.field_23721);
        modifiers.method_26847(offhandModifiers);
        if (mainModifiers != null) {
            modifiers.method_26854(mainModifiers);
        }
        return damage;
    }

    public static boolean dealDefaultDamage(class_1309 attacker, class_1297 target, float damage) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            return target.method_5643(target.method_48923().method_48802(player), damage);
        }
        return target.method_5643(target.method_48923().method_48812(attacker), damage);
    }

    public static boolean attackEntity(class_1799 stack, class_1657 attacker, class_1297 targetEntity) {
        return ToolAttackUtil.attackEntity(ToolStack.from(stack), attacker, targetEntity);
    }

    public static boolean attackEntity(IToolStackView tool, class_1657 attacker, class_1297 targetEntity) {
        return ToolAttackUtil.attackEntity(tool, (class_1309)attacker, class_1268.field_5808, targetEntity, ToolAttackUtil.getCooldownFunction(attacker, class_1268.field_5808), false);
    }

    public static boolean attackEntity(IToolStackView tool, class_1309 attackerLiving, class_1268 hand, class_1297 targetEntity, DoubleSupplier cooldownFunction, boolean isExtraAttack) {
        return ToolAttackUtil.attackEntity(tool, attackerLiving, hand, targetEntity, cooldownFunction, isExtraAttack, Util.getSlotType(hand));
    }

    @Nullable
    public static class_1309 getLivingEntity(class_1297 entity) {
        class_1309 living;
        if (entity instanceof PartEntity) {
            PartEntity part = (PartEntity)entity;
            entity = part.getParent();
        }
        return entity instanceof class_1309 ? (living = (class_1309)entity) : null;
    }

    public static boolean attackEntity(IToolStackView tool, class_1309 attackerLiving, class_1268 hand, class_1297 targetEntity, DoubleSupplier cooldownFunction, boolean isExtraAttack, class_1304 sourceSlot) {
        class_1937 class_19372;
        boolean isMagic;
        class_3414 sound;
        if (tool.isBroken() || !tool.hasTag(TinkerTags.Items.MELEE_OR_UNARMED)) {
            return false;
        }
        if (attackerLiving.method_37908().field_9236 || !targetEntity.method_5732() || targetEntity.method_5698((class_1297)attackerLiving)) {
            return true;
        }
        class_1309 targetLiving = ToolAttackUtil.getLivingEntity(targetEntity);
        class_1657 attackerPlayer = null;
        if (attackerLiving instanceof class_1657) {
            class_1657 player;
            attackerPlayer = player = (class_1657)attackerLiving;
        }
        float damage = ToolAttackUtil.getAttributeAttackDamage(tool, attackerLiving, sourceSlot);
        float cooldown = (float)cooldownFunction.getAsDouble();
        boolean fullyCharged = cooldown > 0.9f;
        boolean isCritical = !isExtraAttack && fullyCharged && attackerLiving.field_6017 > 0.0f && !attackerLiving.method_24828() && !attackerLiving.method_6101() && !attackerLiving.method_5799() && !attackerLiving.method_6059(class_1294.field_5919) && !attackerLiving.method_5765() && targetLiving != null && !attackerLiving.method_5624();
        ToolAttackContext context = new ToolAttackContext(attackerLiving, attackerPlayer, hand, sourceSlot, targetEntity, targetLiving, isCritical, cooldown, isExtraAttack);
        float baseDamage = damage;
        List<ModifierEntry> modifiers = tool.getModifierList();
        for (ModifierEntry entry : modifiers) {
            damage = entry.getHook(TinkerHooks.MELEE_DAMAGE).getMeleeDamage(tool, entry, context, baseDamage, damage);
        }
        if (damage <= 0.0f) {
            return !isExtraAttack;
        }
        float knockback = (float)attackerLiving.method_26825(class_5134.field_23722) / 2.0f;
        if (targetLiving != null) {
            knockback += 0.4f;
        }
        if (attackerLiving.method_5624() && fullyCharged) {
            sound = class_3417.field_14999;
            knockback += 0.5f;
        } else {
            sound = fullyCharged ? class_3417.field_14840 : class_3417.field_14625;
        }
        if (!isExtraAttack) {
            float criticalModifier;
            float f = criticalModifier = isCritical ? 1.5f : 1.0f;
            if (isCritical) {
                damage *= criticalModifier;
            }
        }
        boolean bl = isMagic = damage > baseDamage;
        if (cooldown < 1.0f) {
            damage *= 0.2f + cooldown * cooldown * 0.8f;
        }
        float oldHealth = 0.0f;
        if (targetLiving != null) {
            oldHealth = targetLiving.method_6032();
        }
        float baseKnockback = knockback;
        for (ModifierEntry entry : modifiers) {
            knockback = entry.getHook(TinkerHooks.MELEE_HIT).beforeMeleeHit(tool, entry, context, damage, baseKnockback, knockback);
        }
        ModifierLootingHandler.setLootingSlot(attackerLiving, sourceSlot);
        Optional<class_1324> knockbackModifier = ToolAttackUtil.getKnockbackAttribute(targetLiving);
        boolean canceledKnockback = false;
        if (knockback < 0.4f) {
            canceledKnockback = true;
            knockbackModifier.ifPresent(ToolAttackUtil::disableKnockback);
        } else if (targetLiving != null) {
            knockback -= 0.4f;
        }
        boolean didHit = isExtraAttack ? ToolAttackUtil.dealDefaultDamage(attackerLiving, targetEntity, damage) : tool.getDefinition().getData().getAttack().dealDamage(tool, context, damage);
        ModifierLootingHandler.setLootingSlot(attackerLiving, class_1304.field_6173);
        if (canceledKnockback) {
            knockbackModifier.ifPresent(ToolAttackUtil::enableKnockback);
        }
        if (!didHit) {
            if (!isExtraAttack) {
                attackerLiving.method_37908().method_43128(null, attackerLiving.method_23317(), attackerLiving.method_23318(), attackerLiving.method_23321(), class_3417.field_14914, attackerLiving.method_5634(), 1.0f, 1.0f);
            }
            for (ModifierEntry entry : modifiers) {
                entry.getHook(TinkerHooks.MELEE_HIT).failedMeleeHit(tool, entry, context, damage);
            }
            return !isExtraAttack;
        }
        float damageDealt = damage;
        if (targetLiving != null) {
            damageDealt = oldHealth - targetLiving.method_6032();
        }
        if (knockback > 0.0f) {
            if (targetLiving != null) {
                targetLiving.method_6005((double)knockback, (double)class_3532.method_15374((float)(attackerLiving.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(attackerLiving.method_36454() * ((float)Math.PI / 180)))));
            } else {
                targetEntity.method_5762((double)(-class_3532.method_15374((float)(attackerLiving.method_36454() * ((float)Math.PI / 180))) * knockback), 0.1, (double)(class_3532.method_15362((float)(attackerLiving.method_36454() * ((float)Math.PI / 180))) * knockback));
            }
            attackerLiving.method_18799(attackerLiving.method_18798().method_18805(0.6, 1.0, 0.6));
            attackerLiving.method_5728(false);
        }
        if (targetEntity.field_6037 && targetEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)targetEntity;
            serverPlayer.field_13987.method_14364((class_2596)new class_2743(targetEntity));
            targetEntity.field_6037 = false;
        }
        if (attackerPlayer != null) {
            if (isCritical) {
                sound = class_3417.field_15016;
                attackerPlayer.method_7277(targetEntity);
            }
            if (isMagic) {
                attackerPlayer.method_7304(targetEntity);
            }
            attackerLiving.method_37908().method_43128(null, attackerLiving.method_23317(), attackerLiving.method_23318(), attackerLiving.method_23321(), sound, attackerLiving.method_5634(), 1.0f, 1.0f);
        }
        if (damageDealt > 2.0f && (class_19372 = attackerLiving.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            int particleCount = (int)(damageDealt * 0.5f);
            server.method_14199((class_2394)class_2398.field_11209, targetEntity.method_23317(), targetEntity.method_23323(0.5), targetEntity.method_23321(), particleCount, 0.1, 0.0, 0.1, 0.2);
        }
        attackerLiving.method_6114(targetEntity);
        if (targetLiving != null) {
            class_1890.method_8210((class_1309)targetLiving, (class_1297)attackerLiving);
        }
        for (ModifierEntry entry : modifiers) {
            entry.getHook(TinkerHooks.MELEE_HIT).afterMeleeHit(tool, entry, context, damageDealt);
        }
        float speed = tool.getStats().get(ToolStats.ATTACK_SPEED).floatValue();
        int time = Math.round(20.0f / speed);
        if (time < targetEntity.field_6008) {
            targetEntity.field_6008 = (targetEntity.field_6008 + time) / 2;
        }
        if (attackerPlayer != null) {
            if (targetLiving != null) {
                class_1799 held;
                if (!(attackerLiving.method_37908().field_9236 || isExtraAttack || (held = attackerLiving.method_6118(sourceSlot)).method_7960())) {
                    held.method_7979(targetLiving, attackerPlayer);
                }
                attackerPlayer.method_7339(class_3468.field_15399, Math.round(damageDealt * 10.0f));
            }
            attackerPlayer.method_7322(0.1f);
            if (!isExtraAttack) {
                attackerPlayer.method_7259(class_3468.field_15372.method_14956((Object)tool.getItem()));
            }
        }
        if (!tool.hasTag(TinkerTags.Items.UNARMED)) {
            int durabilityLost;
            int n = durabilityLost = targetLiving != null ? 1 : 0;
            if (!tool.hasTag(TinkerTags.Items.MELEE_PRIMARY)) {
                durabilityLost *= 2;
            }
            ToolDamageUtil.damageAnimated(tool, durabilityLost, attackerLiving);
        }
        return true;
    }

    public static boolean extraEntityAttack(IToolStackView tool, class_1309 attackerLiving, class_1268 hand, class_1297 targetEntity) {
        return ToolAttackUtil.attackEntity(tool, attackerLiving, hand, targetEntity, NO_COOLDOWN, true);
    }

    public static void spawnAttackParticle(class_2394 particleData, class_1297 entity, double height) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            double xd = -class_3532.method_15374((float)(entity.method_36454() / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(entity.method_36455() / 180.0f * (float)Math.PI));
            double zd = class_3532.method_15362((float)(entity.method_36454() / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(entity.method_36455() / 180.0f * (float)Math.PI));
            double yd = -class_3532.method_15374((float)(entity.method_36455() / 180.0f * (float)Math.PI));
            server.method_14199(particleData, entity.method_23317() + xd, entity.method_23318() + (double)entity.method_17682() * height, entity.method_23321() + zd, 0, xd, yd, zd, 0.0);
        }
    }

    private static Optional<class_1324> getKnockbackAttribute(@Nullable class_1309 living) {
        return Optional.ofNullable(living).map(e -> e.method_5996(class_5134.field_23718)).filter(attribute -> !attribute.method_6196(ANTI_KNOCKBACK_MODIFIER));
    }

    private static void disableKnockback(class_1324 instance) {
        instance.method_26835(ANTI_KNOCKBACK_MODIFIER);
    }

    private static void enableKnockback(class_1324 instance) {
        instance.method_6202(ANTI_KNOCKBACK_MODIFIER);
    }

    public static boolean attackEntitySecondary(class_1282 source, float damage, class_1297 target, @Nullable class_1309 living, boolean noKnockback) {
        float oldLastDamage;
        Optional<class_1324> knockbackResistance = ToolAttackUtil.getKnockbackAttribute(living);
        float f = oldLastDamage = living == null ? 0.0f : living.field_6253;
        if (noKnockback) {
            knockbackResistance.ifPresent(ToolAttackUtil::disableKnockback);
        }
        int lastInvulnerableTime = target.field_6008;
        target.field_6008 = 0;
        boolean hit = target.method_5643(source, damage);
        target.field_6008 = lastInvulnerableTime;
        if (living != null) {
            living.field_6253 += oldLastDamage;
        }
        if (noKnockback) {
            knockbackResistance.ifPresent(ToolAttackUtil::enableKnockback);
        }
        return hit;
    }
}

